/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.svg;

import gg.essential.elementa.svg.data.Point;
import gg.essential.elementa.svg.data.SVGArc;
import gg.essential.elementa.svg.data.SVGCubicCurve;
import gg.essential.elementa.svg.data.SVGElement;
import gg.essential.elementa.svg.data.SVGLine;
import gg.essential.elementa.svg.data.SVGQuadraticCurve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u00020\u0014\"\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\nH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020!0%H\u0002J\"\u0010(\u001a\b\u0012\u0004\u0012\u0002H)0\u001b\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+H\u0002J\b\u0010,\u001a\u00020\u0011H\u0002J\b\u0010-\u001a\u00020!H\u0002J\u0012\u0010.\u001a\u00020\u00192\b\b\u0002\u0010/\u001a\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgg/essential/elementa/svg/PathParser;", "", "dataString", "", "(Ljava/lang/String;)V", "char", "", "getChar", "()C", "currentPos", "Lgg/essential/elementa/svg/data/Point;", "cursor", "", "firstPos", "charForPrinting", "consume", "isDone", "", "match", "chars", "", "matchCommaWhitespace", "matchCoordinate", "matchWhitespace", "optionalParseCommaWhitespace", "", "parse", "", "Lgg/essential/elementa/svg/data/SVGElement;", "parseArc", "absolute", "parseCommaWhitespace", "parseCoordinate", "", "parseCoordinatePair", "parseCoordinatePairDouble", "parseCoordinatePairSequence", "", "parseCoordinatePairTriple", "parseCoordinateSequence", "parseCurveto", "T", "generator", "Lkotlin/Function0;", "parseFlag", "parseNumber", "parseWhitespace", "mustMatchOnce", "Companion", "PathParseException", "Elementa"})
@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\ngg/essential/elementa/svg/PathParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,384:1\n1849#2,2:385\n1849#2,2:387\n1849#2,2:389\n1849#2:391\n1547#2:392\n1618#2,3:393\n1850#2:396\n1849#2:397\n1547#2:398\n1618#2,3:399\n1850#2:402\n1849#2:403\n1547#2:404\n1618#2,3:405\n1850#2:408\n1849#2,2:409\n1547#2:411\n1618#2,3:412\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\ngg/essential/elementa/svg/PathParser\n*L\n22#1:385,2\n35#1:387,2\n57#1:389,2\n94#1:391\n100#1:392\n100#1:393,3\n94#1:396\n117#1:397\n123#1:398\n123#1:399,3\n117#1:402\n147#1:403\n153#1:404\n153#1:405,3\n147#1:408\n170#1:409,2\n380#1:411\n380#1:412,3\n*E\n"})
public final class PathParser {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private String dataString;
    @NotNull
    private final Point currentPos;
    @Nullable
    private Point firstPos;
    private int cursor;
    @NotNull
    private static final List<Character> whitespaceChars;

    public PathParser(@NotNull String dataString) {
        Intrinsics.checkNotNullParameter(dataString, "dataString");
        this.dataString = dataString;
        this.currentPos = new Point(0.0f, 0.0f);
    }

    private final char getChar() {
        return this.dataString.charAt(this.cursor);
    }

    @NotNull
    public final List<SVGElement> parse() {
        List elements = new ArrayList();
        while (!this.isDone()) {
            char command;
            block48: {
                List points2;
                Point point;
                float y;
                float x;
                Collection collection;
                Point point2;
                Iterable $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Object it;
                Iterable $this$forEach$iv;
                char c;
                boolean absolute;
                block45: {
                    Object object;
                    Point point3;
                    command = this.consume();
                    absolute = Character.toUpperCase(command) == command;
                    c = Character.toUpperCase(command);
                    if (c == 'M') {
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        $this$forEach$iv = this.parseCoordinatePairSequence();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            point3 = (Point)element$iv;
                            boolean bl = false;
                            float x2 = point3.component1();
                            float y2 = point3.component2();
                            if (absolute) {
                                this.currentPos.setX(x2);
                                this.currentPos.setY(y2);
                                continue;
                            }
                            Point point4 = this.currentPos;
                            point4.setX(point4.getX() + x2);
                            point4 = this.currentPos;
                            point4.setY(point4.getY() + y2);
                        }
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        continue;
                    }
                    if (c == 'L') {
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        $this$forEach$iv = this.parseCoordinatePairSequence();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            point3 = (Point)element$iv;
                            boolean bl = false;
                            float x3 = point3.component1();
                            float y3 = point3.component2();
                            Point originalPoint = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                            if (this.firstPos == null) {
                                this.firstPos = originalPoint;
                            }
                            if (absolute) {
                                this.currentPos.setX(x3);
                                this.currentPos.setY(y3);
                            } else {
                                object = this.currentPos;
                                ((Point)object).setX(((Point)object).getX() + x3);
                                object = this.currentPos;
                                ((Point)object).setY(((Point)object).getY() + y3);
                            }
                            elements.add(new SVGLine(originalPoint, Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null)));
                        }
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        continue;
                    }
                    if (c == 'H' ? true : c == 'V') {
                        Object element$iv;
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        KMutableProperty0 field2 = Character.toUpperCase(command) == 'H' ? (KMutableProperty0)new MutablePropertyReference0Impl(this.currentPos){

                            @Nullable
                            public Object get() {
                                return Float.valueOf(((Point)this.receiver).getX());
                            }

                            public void set(@Nullable Object value) {
                                ((Point)this.receiver).setX(((Number)value).floatValue());
                            }
                        } : (KMutableProperty0)new MutablePropertyReference0Impl(this.currentPos){

                            @Nullable
                            public Object get() {
                                return Float.valueOf(((Point)this.receiver).getY());
                            }

                            public void set(@Nullable Object value) {
                                ((Point)this.receiver).setY(((Number)value).floatValue());
                            }
                        };
                        Iterable $this$forEach$iv2 = this.parseCoordinateSequence();
                        boolean $i$f$forEach = false;
                        element$iv = $this$forEach$iv2.iterator();
                        while (element$iv.hasNext()) {
                            Object element$iv2 = element$iv.next();
                            float it2 = ((Number)element$iv2).floatValue();
                            boolean bl = false;
                            Point originalPoint = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                            if (this.firstPos == null) {
                                this.firstPos = originalPoint;
                            }
                            if (absolute) {
                                field2.set(Float.valueOf(it2));
                            } else {
                                field2.set(Float.valueOf(((Number)field2.get()).floatValue() + it2));
                            }
                            elements.add(new SVGLine(originalPoint, Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null)));
                        }
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        continue;
                    }
                    if (c == 'Z') {
                        if (this.firstPos == null) {
                            throw new PathParseException(command + " instruction encountered with no previous position data");
                        }
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        Point point5 = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                        Point point6 = this.firstPos;
                        Intrinsics.checkNotNull(point6);
                        elements.add(new SVGLine(point5, point6));
                        this.firstPos = null;
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        continue;
                    }
                    if (c == 'A') {
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        do {
                            elements.add(this.parseArc(absolute));
                        } while (this.matchCoordinate());
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        continue;
                    }
                    if (c == 'C') {
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        $this$forEach$iv = this.parseCurveto((Function0)new Function0<List<? extends Point>>((Object)this){

                            @NotNull
                            public final List<Point> invoke() {
                                return PathParser.access$parseCoordinatePairTriple((PathParser)this.receiver);
                            }
                        });
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (List)element$iv;
                            boolean bl = false;
                            Point originalPoint = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                            if (this.firstPos == null) {
                                this.firstPos = originalPoint;
                            }
                            Iterable $this$map$iv = (Iterable)it;
                            boolean $i$f$map = false;
                            object = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                point2 = (Point)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl2 = false;
                                x = point2.component1();
                                y = point2.component2();
                                if (absolute) {
                                    this.currentPos.setX(x);
                                    this.currentPos.setY(y);
                                } else {
                                    point = this.currentPos;
                                    point.setX(point.getX() + x);
                                    point = this.currentPos;
                                    point.setY(point.getY() + y);
                                }
                                collection.add(Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null));
                            }
                            points2 = (List)destination$iv$iv;
                            elements.add(new SVGCubicCurve(originalPoint, (Point)points2.get(0), (Point)points2.get(1), (Point)points2.get(2), 0, 16, null));
                        }
                        PathParser.parseWhitespace$default(this, false, 1, null);
                        continue;
                    }
                    if (c != 'S') break block45;
                    PathParser.parseWhitespace$default(this, false, 1, null);
                    $this$forEach$iv = this.parseCurveto((Function0)new Function0<List<? extends Point>>((Object)this){

                        @NotNull
                        public final List<Point> invoke() {
                            return PathParser.access$parseCoordinatePairDouble((PathParser)this.receiver);
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Object object2;
                        Point originalPoint;
                        block47: {
                            block46: {
                                it = (List)element$iv;
                                boolean bl = false;
                                originalPoint = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                                if (this.firstPos == null) {
                                    this.firstPos = originalPoint;
                                }
                                Iterable $this$map$iv = (Iterable)it;
                                boolean $i$f$map = false;
                                $this$mapTo$iv$iv = $this$map$iv;
                                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo2 = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    point2 = (Point)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl3 = false;
                                    x = point2.component1();
                                    y = point2.component2();
                                    if (absolute) {
                                        this.currentPos.setX(x);
                                        this.currentPos.setY(y);
                                    } else {
                                        point = this.currentPos;
                                        point.setX(point.getX() + x);
                                        point = this.currentPos;
                                        point.setY(point.getY() + y);
                                    }
                                    collection.add(Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null));
                                }
                                points2 = (List)destination$iv$iv;
                                object2 = (SVGElement)CollectionsKt.lastOrNull(elements);
                                if (object2 == null) break block46;
                                Object element = destination$iv$iv = object2;
                                boolean bl4 = false;
                                Point point7 = !(element instanceof SVGCubicCurve) ? null : ((SVGCubicCurve)element).getLastControlPoint().reflectedAround(originalPoint);
                                object2 = point7;
                                if (point7 != null) break block47;
                            }
                            object2 = originalPoint;
                        }
                        Object firstControlPoint = object2;
                        elements.add(new SVGCubicCurve(originalPoint, (Point)firstControlPoint, (Point)points2.get(0), (Point)points2.get(1), 0, 16, null));
                    }
                    PathParser.parseWhitespace$default(this, false, 1, null);
                    continue;
                }
                if (c == 'Q') {
                    PathParser.parseWhitespace$default(this, false, 1, null);
                    $this$forEach$iv = this.parseCurveto((Function0)new Function0<List<? extends Point>>((Object)this){

                        @NotNull
                        public final List<Point> invoke() {
                            return PathParser.access$parseCoordinatePairDouble((PathParser)this.receiver);
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (List)element$iv;
                        boolean bl = false;
                        Point originalPoint = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                        if (this.firstPos == null) {
                            this.firstPos = originalPoint;
                        }
                        Iterable $this$map$iv = (Iterable)it;
                        boolean $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            point2 = (Point)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl5 = false;
                            x = point2.component1();
                            y = point2.component2();
                            if (absolute) {
                                this.currentPos.setX(x);
                                this.currentPos.setY(y);
                            } else {
                                point = this.currentPos;
                                point.setX(point.getX() + x);
                                point = this.currentPos;
                                point.setY(point.getY() + y);
                            }
                            collection.add(Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null));
                        }
                        points2 = (List)destination$iv$iv;
                        elements.add(new SVGQuadraticCurve(originalPoint, (Point)points2.get(0), (Point)points2.get(1), 0, 8, null));
                    }
                    PathParser.parseWhitespace$default(this, false, 1, null);
                    continue;
                }
                if (c != 'T') break block48;
                PathParser.parseWhitespace$default(this, false, 1, null);
                $this$forEach$iv = this.parseCurveto((Function0)new Function0<Point>((Object)this){

                    @NotNull
                    public final Point invoke() {
                        return PathParser.access$parseCoordinatePair((PathParser)this.receiver);
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    Point originalPoint;
                    block50: {
                        block49: {
                            SVGElement sVGElement;
                            it = (Point)element$iv;
                            boolean bl = false;
                            originalPoint = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
                            if (this.firstPos == null) {
                                this.firstPos = originalPoint;
                            }
                            if (absolute) {
                                this.currentPos.setX(((Point)it).getX());
                                this.currentPos.setY(((Point)it).getY());
                            } else {
                                Point $this$map$iv = this.currentPos;
                                $this$map$iv.setX($this$map$iv.getX() + ((Point)it).getX());
                                $this$map$iv = this.currentPos;
                                $this$map$iv.setY($this$map$iv.getY() + ((Point)it).getY());
                            }
                            if ((object = (SVGElement)CollectionsKt.lastOrNull(elements)) == null) break block49;
                            SVGElement element = sVGElement = object;
                            boolean bl6 = false;
                            Point point8 = !(element instanceof SVGQuadraticCurve) ? null : ((SVGQuadraticCurve)element).getLastControlPoint().reflectedAround(originalPoint);
                            object = point8;
                            if (point8 != null) break block50;
                        }
                        object = originalPoint;
                    }
                    Object firstControlPoint = object;
                    elements.add(new SVGQuadraticCurve(originalPoint, (Point)firstControlPoint, this.currentPos, 0, 8, null));
                }
                PathParser.parseWhitespace$default(this, false, 1, null);
                continue;
            }
            throw new PathParseException("Invalid instruction: " + command);
        }
        return elements;
    }

    private final <T> List<T> parseCurveto(Function0<? extends T> generator) {
        List list = new ArrayList();
        list.add(generator.invoke());
        if (this.matchCommaWhitespace()) {
            int prevCursor = this.cursor;
            this.parseCommaWhitespace();
            if (this.matchCoordinate()) {
                list.addAll((Collection)this.parseCurveto(generator));
            } else {
                this.cursor = prevCursor;
            }
        }
        return list;
    }

    private final SVGElement parseArc(boolean absolute) {
        float rX = this.parseNumber();
        this.optionalParseCommaWhitespace();
        float rY = this.parseNumber();
        this.optionalParseCommaWhitespace();
        float xAxisRotation = this.parseNumber();
        this.parseCommaWhitespace();
        boolean largeArc = this.parseFlag();
        this.optionalParseCommaWhitespace();
        boolean sweep = this.parseFlag();
        this.optionalParseCommaWhitespace();
        float x = this.parseCoordinate();
        this.optionalParseCommaWhitespace();
        float y = this.parseCoordinate();
        Point originalPos = Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null);
        if (absolute) {
            this.currentPos.setX(x);
            this.currentPos.setY(y);
        } else {
            Point point = this.currentPos;
            point.setX(point.getX() + x);
            point = this.currentPos;
            point.setY(point.getY() + y);
        }
        if (Intrinsics.areEqual(this.currentPos, originalPos)) {
            throw new PathParseException("Arc x and y position is the same as the previous position");
        }
        if (rX == 0.0f || rY == 0.0f) {
            return new SVGLine(originalPos, Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null));
        }
        return new SVGArc(originalPos, rX, rY, (int)xAxisRotation, largeArc, sweep, Point.copy$default(this.currentPos, 0.0f, 0.0f, 3, null));
    }

    private final float parseCoordinate() {
        char[] cArray = new char[]{'-', '+'};
        return (float)(this.match(cArray) ? (this.consume() == '-' ? -1 : 1) : 1) * this.parseNumber();
    }

    private final List<Point> parseCoordinatePairTriple() {
        List list;
        List $this$parseCoordinatePairTriple_u24lambda_u2412 = list = (List)new ArrayList();
        boolean bl = false;
        $this$parseCoordinatePairTriple_u24lambda_u2412.add(this.parseCoordinatePair());
        this.optionalParseCommaWhitespace();
        $this$parseCoordinatePairTriple_u24lambda_u2412.add(this.parseCoordinatePair());
        this.optionalParseCommaWhitespace();
        $this$parseCoordinatePairTriple_u24lambda_u2412.add(this.parseCoordinatePair());
        return list;
    }

    private final List<Point> parseCoordinatePairDouble() {
        List list;
        List $this$parseCoordinatePairDouble_u24lambda_u2413 = list = (List)new ArrayList();
        boolean bl = false;
        $this$parseCoordinatePairDouble_u24lambda_u2413.add(this.parseCoordinatePair());
        this.optionalParseCommaWhitespace();
        $this$parseCoordinatePairDouble_u24lambda_u2413.add(this.parseCoordinatePair());
        return list;
    }

    private final Point parseCoordinatePair() {
        float x = this.parseCoordinate();
        this.optionalParseCommaWhitespace();
        return new Point(x, this.parseCoordinate());
    }

    private final List<Float> parseCoordinateSequence() {
        List list;
        List it = list = (List)new ArrayList();
        boolean bl = false;
        do {
            it.add(Float.valueOf(this.parseCoordinate()));
            this.optionalParseCommaWhitespace();
        } while (this.matchCommaWhitespace() || this.matchCoordinate());
        return list;
    }

    private final List<Point> parseCoordinatePairSequence() {
        List list;
        List it = list = (List)new ArrayList();
        boolean bl = false;
        do {
            it.add(this.parseCoordinatePair());
            this.optionalParseCommaWhitespace();
        } while (this.matchCommaWhitespace() || this.matchCoordinate());
        return list;
    }

    private final void parseWhitespace(boolean mustMatchOnce) {
        boolean matched = false;
        while (!this.isDone() && this.matchWhitespace()) {
            this.consume();
            matched = true;
        }
        if (mustMatchOnce && !matched) {
            throw new PathParseException("Expected whitespace at position " + this.cursor + ", got " + this.charForPrinting());
        }
    }

    static /* synthetic */ void parseWhitespace$default(PathParser pathParser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        pathParser.parseWhitespace(bl);
    }

    private final void optionalParseCommaWhitespace() {
        if (this.matchCommaWhitespace()) {
            this.parseCommaWhitespace();
        }
    }

    private final void parseCommaWhitespace() {
        char[] cArray = new char[]{','};
        if (this.match(cArray)) {
            this.consume();
            PathParser.parseWhitespace$default(this, false, 1, null);
        } else {
            this.parseWhitespace(true);
            cArray = new char[]{','};
            if (this.match(cArray)) {
                this.consume();
            }
            PathParser.parseWhitespace$default(this, false, 1, null);
        }
    }

    private final float parseNumber() {
        StringBuilder builder = new StringBuilder();
        PathParser.parseNumber$appendDigits(this, builder);
        char[] cArray = new char[]{'.'};
        if (this.match(cArray)) {
            builder.append(this.consume());
            PathParser.parseNumber$appendDigits(this, builder);
        } else if (((CharSequence)builder).length() == 0) {
            throw new PathParseException("Expected number at position " + this.cursor + ", got " + this.charForPrinting());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "builder.toString()");
        Float f = StringsKt.toFloatOrNull(string);
        if (f == null) {
            throw new PathParseException("Expected number at position " + this.cursor + ", got " + builder);
        }
        float number = f.floatValue();
        char[] cArray2 = new char[]{'e', 'E'};
        if (this.match(cArray2)) {
            throw new PathParseException("Numeric 'e' format is not supported");
        }
        return number;
    }

    private final boolean parseFlag() {
        char[] cArray = new char[]{'0', '1'};
        if (!this.match(cArray)) {
            throw new PathParseException("Expected 0 or 1 at position " + this.cursor + ", got " + this.charForPrinting());
        }
        return this.consume() == '1';
    }

    private final boolean match(char ... chars) {
        return !this.isDone() && ArraysKt.contains(chars, this.getChar());
    }

    private final boolean matchWhitespace() {
        return !this.isDone() && whitespaceChars.contains(Character.valueOf(this.getChar()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchCommaWhitespace() {
        if (this.isDone()) return false;
        if (whitespaceChars.contains(Character.valueOf(this.getChar()))) return true;
        char[] cArray = new char[]{','};
        if (!this.match(cArray)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchCoordinate() {
        if (this.isDone()) return false;
        if (Character.isDigit(this.getChar())) return true;
        char[] cArray = new char[]{'-', ',', '.'};
        if (!this.match(cArray)) return false;
        return true;
    }

    private final char consume() {
        int n = this.cursor;
        this.cursor = n + 1;
        return this.dataString.charAt(n);
    }

    private final boolean isDone() {
        return this.cursor >= this.dataString.length();
    }

    private final String charForPrinting() {
        return this.isDone() ? "<end>" : String.valueOf(this.getChar());
    }

    private static final void parseNumber$appendDigits(PathParser this$0, StringBuilder builder) {
        while (!this$0.isDone() && Character.isDigit(this$0.getChar())) {
            builder.append(this$0.consume());
        }
    }

    public static final /* synthetic */ List access$parseCoordinatePairTriple(PathParser $this) {
        return $this.parseCoordinatePairTriple();
    }

    public static final /* synthetic */ List access$parseCoordinatePairDouble(PathParser $this) {
        return $this.parseCoordinatePairDouble();
    }

    public static final /* synthetic */ Point access$parseCoordinatePair(PathParser $this) {
        return $this.parseCoordinatePair();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Integer[] integerArray = new Integer[]{9, 32, 10, 12, 13};
        Iterable $this$map$iv = CollectionsKt.listOf(integerArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)it));
        }
        whitespaceChars = (List)var3_3;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/elementa/svg/PathParser$Companion;", "", "()V", "whitespaceChars", "", "", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lgg/essential/elementa/svg/PathParser$PathParseException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "Elementa"})
    public static final class PathParseException
    extends Exception {
        public PathParseException(@NotNull String message) {
            Intrinsics.checkNotNullParameter(message, "message");
            super(message);
        }
    }
}

